<?php
// Check if form is submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Handle file deletion if requested
    if (isset($_POST['delete'])) {
        @unlink(__FILE__);
        die('<h2 style="color: #51cf66;">File successfully deleted!</h2>');
    }

    if (isset($_POST['url'])) {
        // Get URL from form input
        $target_url = trim($_POST['url']);
        $target_host = parse_url($target_url, PHP_URL_HOST);

        echo "<style>body {font-family: Consolas, 'Courier New', monospace;margin: 20px;background-color: #212529;color: #e9ecef;}</style>";

        // Validate URL format
        if (!filter_var($target_url, FILTER_VALIDATE_URL)) {
            die("<h2 style='color: #ff6b6b;'>❌ Error: Invalid URL format</h2>
                <p style='color: #adb5bd;'>Please enter a valid URL (e.g., https://example.com)</p>
                <p><a style='color: #4dabf7;' href='" . htmlspecialchars($_SERVER['PHP_SELF']) . "'>Try Again</a></p>");
        }

        // Set user agent
        ini_set('user_agent', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36');

        // Function to display results
        function displayTestResult($testName, $success, $details = '', $executionTime = null)
        {
            $icon = $success ? '✅' : '❌';
            $color = $success ? '#51cf66' : '#ff6b6b';
            echo "<div style='margin-bottom: 15px;'>";
            echo "<h3 style='color: $color;'>$icon $testName: " . ($success ? 'Success' : 'Failed') .
                ($executionTime !== null ? " <small>(Time: {$executionTime}ms)</small>" : "") . "</h3>";
            if (!empty($details)) {
                echo "<pre style='background: #2b2d42; color: #e9ecef; padding: 10px; border-radius: 5px;'>" . htmlspecialchars($details) . "</pre>";
            }
            echo "</div>";
        }

        // Function to measure execution time
        function measureTime(callable $function) {
            $start = microtime(true);
            $result = $function();
            $time = round((microtime(true) - $start) * 1000, 2);
            return [$result, $time];
        }

        // 1. DNS Lookup Test
        [$dnsResult, $dnsTime] = measureTime(function() use ($target_host) {
            $dnsSuccess = false;
            $dnsDetails = '';
            try {
                $ip = gethostbyname($target_host);
                $dnsSuccess = ($ip !== $target_host);
                $dnsDetails = "Resolved $target_host to $ip";

                // Get DNS records
                $dnsRecords = @dns_get_record($target_host, DNS_ALL);
                if ($dnsRecords) {
                    $dnsDetails .= "\n\nDNS Records:\n" . print_r($dnsRecords, true);
                }
            } catch (Exception $e) {
                $dnsDetails = "DNS lookup failed: " . $e->getMessage();
            }
            return ['success' => $dnsSuccess, 'details' => $dnsDetails];
        });
        displayTestResult('DNS Lookup', $dnsResult['success'], $dnsResult['details'], $dnsTime);

        // 2. Port Check (HTTP/HTTPS)
        [$portResult, $portTime] = measureTime(function() use ($target_host, $target_url) {
            $portCheckSuccess = false;
            $portCheckDetails = '';
            $scheme = parse_url($target_url, PHP_URL_SCHEME);
            $port = $scheme === 'https' ? 443 : 80;

            try {
                $fp = @fsockopen($target_host, $port, $errno, $errstr, 5);
                if ($fp) {
                    $portCheckSuccess = true;
                    $portCheckDetails = "Port $port ($scheme) is open";
                    fclose($fp);
                } else {
                    $portCheckDetails = "Port $port ($scheme) connection failed: $errstr ($errno)";
                }
            } catch (Exception $e) {
                $portCheckDetails = "Port check failed: " . $e->getMessage();
            }
            return ['success' => $portCheckSuccess, 'details' => $portCheckDetails];
        });
        displayTestResult('Port Check', $portResult['success'], $portResult['details'], $portTime);

        // 3. HTTP Content Fetch (file_get_contents)
        [$httpResult, $httpTime] = measureTime(function() use ($target_url) {
            $httpSuccess = false;
            $httpDetails = '';
            try {
                $context = stream_context_create([
                    'http' => [
                        'timeout' => 10,
                        'ignore_errors' => true
                    ]
                ]);
                $content = @file_get_contents($target_url, false, $context);
                if ($content !== false) {
                    $httpSuccess = true;
                    $headers = $http_response_header;
                    $httpDetails = "Headers:\n" . implode("\n", $headers) . "\n\n";
                    $httpDetails .= "Successfully retrieved content (first 200 chars):\n" . substr($content, 0, 200);
                } else {
                    $error = error_get_last();
                    $httpDetails = "file_get_contents failed: " . ($error['message'] ?? 'Unknown error');
                }
            } catch (Exception $e) {
                $httpDetails = "HTTP request failed: " . $e->getMessage();
            }
            return ['success' => $httpSuccess, 'details' => $httpDetails];
        });
        displayTestResult('HTTP Content (file_get_contents)', $httpResult['success'], $httpResult['details'], $httpTime);

        // 4. cURL Check (if available)
        if (function_exists('curl_init')) {
            [$curlResult, $curlTime] = measureTime(function() use ($target_url) {
                $curlSuccess = false;
                $curlDetails = '';
                try {
                    $ch = curl_init();
                    curl_setopt($ch, CURLOPT_URL, $target_url);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
                    curl_setopt($ch, CURLOPT_USERAGENT, ini_get('user_agent'));
                    curl_setopt($ch, CURLOPT_HEADER, true);
                    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
                    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
                    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
                    curl_setopt($ch, CURLOPT_CERTINFO, true);
                    curl_setopt($ch, CURLOPT_VERBOSE, true);

                    $response = curl_exec($ch);
                    $header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
                    $headers = substr($response, 0, $header_size);
                    $content = substr($response, $header_size);

                    if ($response === false) {
                        $curlDetails = "cURL error: " . curl_error($ch);
                    } else {
                        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                        $curlSuccess = ($httpCode >= 200 && $httpCode < 400);

                        // Get redirect info
                        $redirectCount = curl_getinfo($ch, CURLINFO_REDIRECT_COUNT);
                        $finalUrl = curl_getinfo($ch, CURLINFO_EFFECTIVE_URL);

                        // SSL/TLS info
                        $sslInfo = curl_getinfo($ch, CURLINFO_CERTINFO);
                        $sslVerify = curl_getinfo($ch, CURLINFO_SSL_VERIFYRESULT);

                        $curlDetails = "HTTP Status: $httpCode\n";
                        $curlDetails .= "Redirect Count: $redirectCount\n";
                        $curlDetails .= "Final URL: $finalUrl\n";
                        $curlDetails .= "Content Type: " . curl_getinfo($ch, CURLINFO_CONTENT_TYPE) . "\n";

                        // SSL/TLS details
                        $curlDetails .= "\nSSL/TLS Info:\n";
                        $curlDetails .= "SSL Verify Result: " . ($sslVerify === 0 ? 'Success' : "Failed ($sslVerify)") . "\n";
                        if (!empty($sslInfo)) {
                            foreach ($sslInfo[0] as $key => $value) {
                                $curlDetails .= "$key: $value\n";
                            }

                            // Check certificate expiry
                            if (isset($sslInfo[0]['Cert'])) {
                                $cert = openssl_x509_parse($sslInfo[0]['Cert']);
                                if ($cert) {
                                    $validFrom = date('Y-m-d H:i:s', $cert['validFrom_time_t']);
                                    $validTo = date('Y-m-d H:i:s', $cert['validTo_time_t']);
                                    $curlDetails .= "\nCertificate Validity:\n";
                                    $curlDetails .= "Valid From: $validFrom\n";
                                    $curlDetails .= "Valid To: $validTo\n";

                                    // Check if certificate is expired
                                    $now = time();
                                    if ($now > $cert['validTo_time_t']) {
                                        $curlDetails .= "Status: ❌ Certificate EXPIRED\n";
                                    } elseif ($now > ($cert['validTo_time_t'] - (30 * 24 * 60 * 60))) {
                                        $curlDetails .= "Status: ⚠️ Certificate expiring soon (within 30 days)\n";
                                    } else {
                                        $curlDetails .= "Status: ✅ Certificate valid\n";
                                    }
                                }
                            }
                        }

                        $curlDetails .= "\nHeaders:\n" . $headers . "\n";
                        $curlDetails .= "First 200 chars:\n" . substr($content, 0, 200);
                    }

                    curl_close($ch);
                } catch (Exception $e) {
                    $curlDetails = "cURL exception: " . $e->getMessage();
                }
                return ['success' => $curlSuccess, 'details' => $curlDetails];
            });
            displayTestResult('HTTP Content (cURL)', $curlResult['success'], $curlResult['details'], $curlTime);
        }

        // 5. Attempt ICMP Ping (will likely fail on shared hosting)
        $pingSuccess = false;
        $pingDetails = 'ICMP ping not available on this server';

        // Only try if on Linux and exec is not disabled
        if (strtoupper(substr(PHP_OS, 0, 3)) !== 'WIN' && !in_array('exec', explode(',', ini_get('disable_functions')))) {
            [$pingResult, $pingTime] = measureTime(function() use ($target_host) {
                $pingSuccess = false;
                $pingDetails = '';
                try {
                    $pingResult = @exec("ping -c 3 " . escapeshellarg($target_host), $output, $return_var);
                    if ($return_var === 0) {
                        $pingSuccess = true;
                        $pingDetails = implode("\n", $output);
                    } else {
                        $pingDetails = "Ping failed (return code $return_var)\n" . implode("\n", $output);
                    }
                } catch (Exception $e) {
                    $pingDetails = "Ping attempt failed: " . $e->getMessage();
                }
                return ['success' => $pingSuccess, 'details' => $pingDetails];
            });
            displayTestResult('ICMP Ping', $pingResult['success'], $pingResult['details'], $pingTime);
        }

        // Display back link and delete button
        echo "<form method='POST' style='margin-top: 20px;'>";
        echo "<input type='hidden' name='delete' value='1'>";
        echo "<button type='submit' style='padding: 8px 15px; background: #dc3545; color: white; border: none; border-radius: 4px; cursor: pointer; font-weight: bold;'>Delete This Script</button>";
        echo "&nbsp;&nbsp;";
        echo "<a style='color: #4dabf7; padding: 8px 15px; background: #343a40; border-radius: 4px;' href='" . htmlspecialchars($_SERVER['PHP_SELF']) . "'>Test Another URL</a>";
        echo "</form>";

        // Display PHP configuration info (for debugging)
        echo "<hr style='border-color: #495057;'><h3 style='color: #e9ecef;'>PHP Configuration Info:</h3>";
        echo "<pre style='background: #2b2d42; color: #e9ecef; padding: 10px; border-radius: 5px;'>";
        echo "allow_url_fopen: " . (ini_get('allow_url_fopen') ? 'On' : 'Off') . "\n";
        echo "cURL available: " . (function_exists('curl_init') ? 'Yes' : 'No') . "\n";
        echo "Disabled functions: " . ini_get('disable_functions') . "\n";
        echo "PHP OS: " . PHP_OS . "\n";
        echo "</pre>";

        exit;
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Advanced Connectivity Checker</title>
    <style>
        body {
            font-family: Consolas, 'Courier New', monospace;
            margin: 20px;
            background-color: #212529;
            color: #e9ecef;
        }

        .container {
            max-width: 900px;
            margin: 0 auto;
        }

        form {
            background: #2b2d42;
            padding: 20px;
            border-radius: 5px;
        }

        input[type="url"] {
            width: 80%;
            padding: 8px;
            background: #343a40;
            color: #e9ecef;
            border: 1px solid #495057;
            border-radius: 4px;
        }

        input[type="submit"], button {
            padding: 8px 15px;
            background: #20c997;
            color: #000;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-weight: bold;
        }

        input[type="submit"]:hover, button:hover {
            opacity: 0.9;
        }

        pre {
            white-space: pre-wrap;
            word-wrap: break-word;
        }

        h1, h3, small, p, li {
            color: #e9ecef;
            margin: 0;
        }

        hr {
            border-color: #495057;
        }

        a {
            color: #4dabf7;
            text-decoration: none;
        }

        a:hover {
            text-decoration: underline;
        }

        ul {
            padding-left: 20px;
        }

        li {
            margin-bottom: 8px;
        }

        .delete-btn {
            background: #dc3545 !important;
            color: white !important;
        }
    </style>
</head>
<body>
<div class="container">
    <h1>Advanced Connectivity Checker</h1>
    <small>By <a href="https://t.me/r3zaesma3ili/" target="_blank">REZAZOOM</a></small>
    <hr>
    <p>Enter a URL to check various connectivity tests:</p>

    <form method="POST" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>">
        <label for="url">URL:</label><br>
        <input type="url" id="url" name="url" placeholder="https://example.com" required>
        <input type="submit" value="Run Tests">
        <p><small>Please wait a few seconds for tests to finish after you submit the URL.</small></p>
    </form>

    <h3>Tests performed:</h3>
    <ul>
        <li>DNS resolution (including DNS records)</li>
        <li>Port availability (80/443)</li>
        <li>HTTP content via file_get_contents (with headers)</li>
        <li>HTTP content via cURL (with full SSL/TLS verification and certificate info)</li>
        <li>Redirect tracking and final URL</li>
        <li>ICMP ping (if server allows)</li>
        <li>Execution time for each test</li>
    </ul>

    <h3>Note:</h3>
    <ul>
        <li>On shared hosting, ICMP ping will likely fail due to server restrictions. Other tests should work.</li>
        <li>You can delete this script after testing using the delete button in results page.</li>
        <li>SSL/TLS verification is enabled for security.</li>
    </ul>
</div>
</body>
</html>